/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.helpers;

import com.badlogic.gdx.math.MathUtils;
import com.megacrit.cardcrawl.helpers.EnemyData;
import com.megacrit.cardcrawl.metrics.LeaderboardPoster;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.MonsterGroup;
import com.megacrit.cardcrawl.monsters.thebeyond.AwakenedOne;
import com.megacrit.cardcrawl.monsters.thebeyond.Darkling;
import com.megacrit.cardcrawl.monsters.thebeyond.Deca;
import com.megacrit.cardcrawl.monsters.thebeyond.Donu;
import com.megacrit.cardcrawl.monsters.thebeyond.Exploder;
import com.megacrit.cardcrawl.monsters.thebeyond.FireOrb;
import com.megacrit.cardcrawl.monsters.thebeyond.FlameBruiser;
import com.megacrit.cardcrawl.monsters.thebeyond.GiantHead;
import com.megacrit.cardcrawl.monsters.thebeyond.Maw;
import com.megacrit.cardcrawl.monsters.thebeyond.Nemesis;
import com.megacrit.cardcrawl.monsters.thebeyond.OrbWalker;
import com.megacrit.cardcrawl.monsters.thebeyond.Puppeteer;
import com.megacrit.cardcrawl.monsters.thebeyond.Repulsor;
import com.megacrit.cardcrawl.monsters.thebeyond.Serpent;
import com.megacrit.cardcrawl.monsters.thebeyond.Spiker;
import com.megacrit.cardcrawl.monsters.thebeyond.TimeEater;
import com.megacrit.cardcrawl.monsters.thebottom.AcidSlime_L;
import com.megacrit.cardcrawl.monsters.thebottom.AcidSlime_M;
import com.megacrit.cardcrawl.monsters.thebottom.AcidSlime_S;
import com.megacrit.cardcrawl.monsters.thebottom.ApologySlime;
import com.megacrit.cardcrawl.monsters.thebottom.Cultist;
import com.megacrit.cardcrawl.monsters.thebottom.FungiBeast;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinFat;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinNob;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinThief;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinTsundere;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinWarrior;
import com.megacrit.cardcrawl.monsters.thebottom.GremlinWizard;
import com.megacrit.cardcrawl.monsters.thebottom.Hexaghost;
import com.megacrit.cardcrawl.monsters.thebottom.JawWorm;
import com.megacrit.cardcrawl.monsters.thebottom.Lagavulin;
import com.megacrit.cardcrawl.monsters.thebottom.Looter;
import com.megacrit.cardcrawl.monsters.thebottom.LouseDefensive;
import com.megacrit.cardcrawl.monsters.thebottom.LouseNormal;
import com.megacrit.cardcrawl.monsters.thebottom.Sentry;
import com.megacrit.cardcrawl.monsters.thebottom.SlaverBlue;
import com.megacrit.cardcrawl.monsters.thebottom.SlaverRed;
import com.megacrit.cardcrawl.monsters.thebottom.SlimeBoss;
import com.megacrit.cardcrawl.monsters.thebottom.SpikeSlime_L;
import com.megacrit.cardcrawl.monsters.thebottom.SpikeSlime_M;
import com.megacrit.cardcrawl.monsters.thebottom.SpikeSlime_S;
import com.megacrit.cardcrawl.monsters.thebottom.TheGuardian;
import com.megacrit.cardcrawl.monsters.thecity.BanditBear;
import com.megacrit.cardcrawl.monsters.thecity.BanditChild;
import com.megacrit.cardcrawl.monsters.thecity.BanditLeader;
import com.megacrit.cardcrawl.monsters.thecity.BookOfStabbing;
import com.megacrit.cardcrawl.monsters.thecity.BronzeAutomaton;
import com.megacrit.cardcrawl.monsters.thecity.BronzeOrb;
import com.megacrit.cardcrawl.monsters.thecity.Byrd;
import com.megacrit.cardcrawl.monsters.thecity.Centurion;
import com.megacrit.cardcrawl.monsters.thecity.Champ;
import com.megacrit.cardcrawl.monsters.thecity.Chosen;
import com.megacrit.cardcrawl.monsters.thecity.GremlinLeader;
import com.megacrit.cardcrawl.monsters.thecity.Healer;
import com.megacrit.cardcrawl.monsters.thecity.Mugger;
import com.megacrit.cardcrawl.monsters.thecity.ShellMonster;
import com.megacrit.cardcrawl.monsters.thecity.SnakePlant;
import com.megacrit.cardcrawl.monsters.thecity.Snecko;
import com.megacrit.cardcrawl.monsters.thecity.SphericGuardian;
import com.megacrit.cardcrawl.monsters.thecity.Taskmaster;
import com.megacrit.cardcrawl.monsters.thecity.TheCollector;
import com.megacrit.cardcrawl.monsters.thecity.TorchHead;
import com.megacrit.cardcrawl.monsters.thetop.CorruptHeart;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MonsterHelper {
    private static final Logger logger = LogManager.getLogger(MonsterHelper.class.getName());
    private static String lastEncounterName = null;
    private static String currentEncounterName = null;
    private static String lastStrongHumanoid = null;
    public static final String BLUE_SLAVER_ENC = "Blue Slaver";
    public static final String CULTIST_ENC = "Cultist";
    public static final String JAW_WORM_ENC = "Jaw Worm";
    public static final String LOOTER_ENC = "Looter";
    public static final String TWO_LOUSE_ENC = "2 Louse";
    public static final String SMALL_SLIMES_ENC = "Small Slimes";
    public static final String GREMLIN_GANG_ENC = "Gremlin Gang";
    public static final String RED_SLAVER_ENC = "Red Slaver";
    public static final String LARGE_SLIME_ENC = "Large Slime";
    public static final String LVL_1_THUGS_ENC = "Exordium Thugs";
    public static final String LVL_1_WILDLIFE_ENC = "Exordium Wildlife";
    public static final String THREE_LOUSE_ENC = "3 Louse";
    public static final String TWO_FUNGI_ENC = "2 Fungi Beasts";
    public static final String LOTS_OF_SLIMES_ENC = "Lots of Slimes";
    public static final String GREMLIN_NOB_ENC = "Gremlin Nob";
    public static final String LAGAVULIN_ENC = "Lagavulin";
    public static final String THREE_SENTRY_ENC = "3 Sentries";
    public static final String LAGAVULIN_EVENT_ENC = "Lagavulin Event";
    public static final String MUSHROOMS_EVENT_ENC = "Mushrooms";
    public static final String GUARDIAN_ENC = "The Guardian";
    public static final String HEXAGHOST_ENC = "Hexaghost";
    public static final String SLIME_BOSS_ENC = "Slime Boss";
    public static final String TWO_THIEVES_ENC = "2 Thieves";
    public static final String THREE_BYRDS_ENC = "3 Byrds";
    public static final String CHOSEN_ENC = "Chosen";
    public static final String SHELL_PARASITE_ENC = "Shell Parasite";
    public static final String SPHERE_GUARDIAN_ENC = "Spheric Guardian";
    public static final String THREE_CULTISTS_ENC = "3 Cultists";
    public static final String FOUR_BYRDS_ENC = "4 Byrds";
    public static final String CHOSEN_FLOCK_ENC = "Chosen and Byrds";
    public static final String SENTRY_SPHERE_ENC = "Sentry and Sphere";
    public static final String SLAVER_PARASITE_ENC = "Slaver and Parasite";
    public static final String SNAKE_PLANT_ENC = "Snake Plant";
    public static final String SNECKO_ENC = "Snecko";
    public static final String TANK_HEALER_ENC = "Centurion and Healer";
    public static final String STAB_BOOK_ENC = "Book of Stabbing";
    public static final String GREMLIN_LEADER_ENC = "Gremlin Leader";
    public static final String SLAVERS_ENC = "Slavers";
    public static final String MASKED_BANDITS_ENC = "Masked Bandits";
    public static final String AUTOMATON_ENC = "Automaton";
    public static final String CHAMP_ENC = "Champ";
    public static final String COLLECTOR_ENC = "Collector";
    public static final String BRUISER_ONE_ENC = "Flame Bruiser 1 Orb";
    public static final String THREE_DARKLINGS_ENC = "3 Darklings";
    public static final String THREE_SHAPES_ENC = "3 Shapes";
    public static final String ORB_WALKER_ENC = "Orb Walker";
    public static final String BRUISER_TWO_ENC = "Flame Bruiser 2 Orb";
    public static final String SPIRE_GROWTH_ENC = "Spire Growth";
    public static final String PUPPETEER_ENC = "Puppeteer";
    public static final String MAW_ENC = "Maw";
    public static final String FOUR_SHAPES_ENC = "4 Shapes";
    public static final String SPHERE_TWO_SHAPES_ENC = "Sphere and 2 Shapes";
    public static final String TWO_ORB_WALKER_ENC = "2 Orb Walkers";
    public static final String NEMESIS_ENC = "Nemesis";
    public static final String GIANT_HEAD_ENC = "Giant Head";
    public static final String MYSTERIOUS_SPHERE_ENC = "Mysterious Sphere";
    public static final String TIME_EATER_ENC = "Time Eater";
    public static final String AWAKENED_ENC = "Awakened One";
    public static final String DONU_DECA_ENC = "Donu and Deca";
    public static final String APOLOGY_SLIME_ENC = "Apologetic Slime";

    public static MonsterGroup getEncounter(String key) {
        switch (key) {
            case "Blue Slaver": {
                return new MonsterGroup(new SlaverBlue(0.0f, 0.0f));
            }
            case "Cultist": {
                return new MonsterGroup(new Cultist(0.0f, -10.0f));
            }
            case "Jaw Worm": {
                return new MonsterGroup(new JawWorm(0.0f, 25.0f));
            }
            case "Looter": {
                return new MonsterGroup(new Looter(0.0f, 0.0f));
            }
            case "Gremlin Gang": {
                return MonsterHelper.spawnGremlins();
            }
            case "Red Slaver": {
                return new MonsterGroup(new SlaverRed(0.0f, 0.0f));
            }
            case "Large Slime": {
                if (MathUtils.randomBoolean()) {
                    return new MonsterGroup(new AcidSlime_L(0.0f, 0.0f, 0));
                }
                return new MonsterGroup(new SpikeSlime_L(0.0f, 0.0f, 0));
            }
            case "Exordium Thugs": {
                return MonsterHelper.bottomHumanoid();
            }
            case "Exordium Wildlife": {
                return MonsterHelper.bottomWildlife();
            }
            case "3 Louse": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getLouse(-350.0f, 25.0f), MonsterHelper.getLouse(-125.0f, 10.0f), MonsterHelper.getLouse(80.0f, 30.0f)});
            }
            case "2 Louse": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getLouse(-200.0f, 10.0f), MonsterHelper.getLouse(80.0f, 30.0f)});
            }
            case "2 Fungi Beasts": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-400.0f, 30.0f), new FungiBeast(-40.0f, 20.0f)});
            }
            case "Lots of Slimes": {
                return MonsterHelper.spawnManySmallSlimes();
            }
            case "Small Slimes": {
                return MonsterHelper.spawnSmallSlimes();
            }
            case "Gremlin Nob": {
                return new MonsterGroup(new GremlinNob());
            }
            case "Lagavulin": {
                return new MonsterGroup(new Lagavulin(true));
            }
            case "3 Sentries": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-330.0f, 25.0f), new Sentry(-85.0f, 10.0f), new Sentry(140.0f, 30.0f)});
            }
            case "Lagavulin Event": {
                return new MonsterGroup(new Lagavulin(false));
            }
            case "Mushrooms": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-450.0f, 30.0f), new FungiBeast(-145.0f, 20.0f), new FungiBeast(180.0f, 15.0f)});
            }
            case "The Guardian": {
                return new MonsterGroup(new TheGuardian());
            }
            case "Hexaghost": {
                return new MonsterGroup(new Hexaghost());
            }
            case "Slime Boss": {
                return new MonsterGroup(new SlimeBoss());
            }
        }
        switch (key) {
            case "2 Thieves": {
                return new MonsterGroup(new AbstractMonster[]{new Looter(-200.0f, 15.0f), new Mugger(80.0f, 0.0f)});
            }
            case "3 Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-360.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(-80.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(200.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "4 Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-470.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(-210.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(50.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(310.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "Chosen": {
                return new MonsterGroup(new Chosen());
            }
            case "Shell Parasite": {
                return new MonsterGroup(new ShellMonster());
            }
            case "Spheric Guardian": {
                return new MonsterGroup(new SphericGuardian());
            }
            case "3 Cultists": {
                return new MonsterGroup(new AbstractMonster[]{new Cultist(-465.0f, -20.0f, false), new Cultist(-130.0f, 15.0f, false), new Cultist(200.0f, -5.0f)});
            }
            case "Chosen and Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Chosen(80.0f, 0.0f), new Byrd(-170.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "Sentry and Sphere": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-305.0f, 30.0f), new SphericGuardian()});
            }
            case "Slaver and Parasite": {
                return new MonsterGroup(new AbstractMonster[]{new ShellMonster(-355.0f, 10.0f), MonsterHelper.getSlaver(50.0f, -10.0f)});
            }
            case "Snake Plant": {
                return new MonsterGroup(new SnakePlant(-30.0f, -30.0f));
            }
            case "Snecko": {
                return new MonsterGroup(new Snecko());
            }
            case "Centurion and Healer": {
                return new MonsterGroup(new AbstractMonster[]{new Centurion(-200.0f, 15.0f), new Healer(120.0f, 0.0f)});
            }
            case "Book of Stabbing": {
                return new MonsterGroup(new BookOfStabbing());
            }
            case "Gremlin Leader": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.spawnGremlin(-366.0f, -4.0f), MonsterHelper.spawnGremlin(-170.0f, 6.0f), new GremlinLeader()});
            }
            case "Slavers": {
                return new MonsterGroup(new AbstractMonster[]{new SlaverBlue(-385.0f, -15.0f), new Taskmaster(-133.0f, 0.0f), new SlaverRed(125.0f, -30.0f)});
            }
            case "Masked Bandits": {
                return new MonsterGroup(new AbstractMonster[]{new BanditLeader(), new BanditBear(-200.0f, 0.0f), new BanditChild(200.0f, 0.0f)});
            }
            case "Automaton": {
                return new MonsterGroup(new BronzeAutomaton());
            }
            case "Champ": {
                return new MonsterGroup(new Champ());
            }
            case "Collector": {
                return new MonsterGroup(new TheCollector());
            }
        }
        switch (key) {
            case "Flame Bruiser 1 Orb": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f)});
            }
            case "3 Darklings": {
                return new MonsterGroup(new AbstractMonster[]{new Darkling(-440.0f, 10.0f), new Darkling(-140.0f, 30.0f), new Darkling(180.0f, -5.0f)});
            }
            case "3 Shapes": {
                return MonsterHelper.spawnShapes(true);
            }
            case "Orb Walker": {
                return new MonsterGroup(new OrbWalker(-30.0f, 30.0f));
            }
            case "Flame Bruiser 2 Orb": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f), new FireOrb(-180.0f, 80.0f)});
            }
            case "Spire Growth": {
                return new MonsterGroup(new Serpent());
            }
            case "Puppeteer": {
                return new MonsterGroup(new Puppeteer());
            }
            case "Maw": {
                return new MonsterGroup(new Maw(-70.0f, 20.0f));
            }
            case "4 Shapes": {
                return MonsterHelper.spawnShapes(false);
            }
            case "Sphere and 2 Shapes": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getAncientShape(-435.0f, 10.0f), MonsterHelper.getAncientShape(-210.0f, 0.0f), new SphericGuardian(110.0f, 10.0f)});
            }
            case "2 Orb Walkers": {
                return new MonsterGroup(new AbstractMonster[]{new OrbWalker(-250.0f, 42.0f), new OrbWalker(150.0f, 36.0f)});
            }
            case "Nemesis": {
                return new MonsterGroup(new Nemesis());
            }
            case "Giant Head": {
                return new MonsterGroup(new GiantHead());
            }
            case "Mysterious Sphere": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getAncientShape(-475.0f, 10.0f), new OrbWalker(150.0f, 30.0f), MonsterHelper.getAncientShape(-250.0f, 0.0f)});
            }
            case "Time Eater": {
                return new MonsterGroup(new TimeEater());
            }
            case "Awakened One": {
                return new MonsterGroup(new AbstractMonster[]{new AwakenedOne(100.0f, 15.0f), new Cultist(-298.0f, -10.0f, false), new Cultist(-590.0f, 10.0f, false)});
            }
            case "Donu and Deca": {
                return new MonsterGroup(new AbstractMonster[]{new Deca(), new Donu()});
            }
        }
        return MonsterHelper.getMonsterOLD(key);
    }

    public static MonsterGroup getMonsterOLD(String key) {
        lastEncounterName = currentEncounterName;
        currentEncounterName = key;
        switch (key) {
            case "TwoFungiBeasts": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-400.0f, 30.0f), new FungiBeast(-40.0f, 20.0f)});
            }
            case "The Mushroom Lair": {
                return new MonsterGroup(new AbstractMonster[]{new FungiBeast(-450.0f, 30.0f), new FungiBeast(-145.0f, 20.0f), new FungiBeast(180.0f, 15.0f)});
            }
            case "Jaw Worm": {
                return new MonsterGroup(new JawWorm(0.0f, 25.0f));
            }
            case "JawWorm": {
                return new MonsterGroup(new JawWorm(0.0f, 25.0f));
            }
            case "Cultist": {
                return new MonsterGroup(new Cultist(0.0f, -10.0f));
            }
            case "GremlinNob": {
                return new MonsterGroup(new GremlinNob());
            }
            case "Gremlins": {
                return MonsterHelper.spawnGremlins();
            }
            case "Slimes": {
                return MonsterHelper.spawnManySmallSlimes();
            }
            case "Lots of Slimes": {
                return MonsterHelper.spawnManySmallSlimes();
            }
            case "Looter": {
                return new MonsterGroup(new Looter(0.0f, 0.0f));
            }
            case "Lagavulin": {
                return new MonsterGroup(new Lagavulin(true));
            }
            case "Lagavulin Dead Adventurers Fight": {
                return new MonsterGroup(new Lagavulin(false));
            }
            case "Sentries": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-330.0f, 25.0f), new Sentry(-85.0f, 10.0f), new Sentry(140.0f, 30.0f)});
            }
            case "Slaver": {
                return new MonsterGroup(MonsterHelper.getSlaver(0.0f, 0.0f));
            }
            case "Blue Slaver": {
                return new MonsterGroup(new SlaverBlue(0.0f, 0.0f));
            }
            case "Red Slaver": {
                return new MonsterGroup(new SlaverRed(0.0f, 0.0f));
            }
            case "AcidSlime_L": {
                return new MonsterGroup(new AcidSlime_L(0.0f, 0.0f, 0));
            }
            case "SpikeSlime_L": {
                return new MonsterGroup(new SpikeSlime_L(0.0f, 0.0f, 0));
            }
            case "Slime": {
                if (MathUtils.randomBoolean()) {
                    return new MonsterGroup(new AcidSlime_L(0.0f, 0.0f, 0));
                }
                return new MonsterGroup(new SpikeSlime_L(0.0f, 0.0f, 0));
            }
            case "SlimeBoss": {
                return new MonsterGroup(new SlimeBoss());
            }
            case "TheGuardian": {
                return new MonsterGroup(new TheGuardian());
            }
            case "Hexaghost": {
                return new MonsterGroup(new Hexaghost());
            }
            case "Louse": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getLouse(-350.0f, 25.0f), MonsterHelper.getLouse(-125.0f, 10.0f), MonsterHelper.getLouse(80.0f, 30.0f)});
            }
            case "Exordium Wildlife": {
                return MonsterHelper.bottomWildlife();
            }
            case "Exordium Thugs": {
                return MonsterHelper.bottomHumanoid();
            }
            case "SphericGuardian": {
                return new MonsterGroup(new SphericGuardian());
            }
            case "Murder of Cultists": {
                return new MonsterGroup(new AbstractMonster[]{new Cultist(-465.0f, -20.0f, false), new Cultist(-130.0f, 15.0f, false), new Cultist(200.0f, -5.0f)});
            }
            case "BronzeAutomaton": {
                return new MonsterGroup(new BronzeAutomaton());
            }
            case "City Looters": {
                return new MonsterGroup(new AbstractMonster[]{new Looter(-200.0f, 15.0f), new Mugger(80.0f, 0.0f)});
            }
            case "4_Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-470.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(-210.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(50.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(310.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "3_Byrds": {
                return new MonsterGroup(new AbstractMonster[]{new Byrd(-360.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(-80.0f, MathUtils.random(25.0f, 70.0f)), new Byrd(200.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "Champ": {
                return new MonsterGroup(new Champ());
            }
            case "Chosen": {
                return new MonsterGroup(new Chosen());
            }
            case "TheCollector": {
                return new MonsterGroup(new TheCollector());
            }
            case "The Red Mask Bandits": {
                return new MonsterGroup(new AbstractMonster[]{new BanditLeader(), new BanditBear(-200.0f, 0.0f), new BanditChild(200.0f, 0.0f)});
            }
            case "HealerTank": {
                return new MonsterGroup(new AbstractMonster[]{new Centurion(-200.0f, 15.0f), new Healer(120.0f, 0.0f)});
            }
            case "Shelled Parasite": {
                return new MonsterGroup(new ShellMonster());
            }
            case "Snecko": {
                return new MonsterGroup(new Snecko());
            }
            case "BookOfStabbing": {
                return new MonsterGroup(new BookOfStabbing());
            }
            case "SlaverBoss": {
                return new MonsterGroup(new AbstractMonster[]{new SlaverBlue(-385.0f, -15.0f), new Taskmaster(-133.0f, 0.0f), new SlaverRed(125.0f, -30.0f)});
            }
            case "Gremlin Leader Combat": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.spawnGremlin(-366.0f, -4.0f), MonsterHelper.spawnGremlin(-170.0f, 6.0f), new GremlinLeader()});
            }
            case "Chosen and Flock": {
                return new MonsterGroup(new AbstractMonster[]{new Chosen(80.0f, 0.0f), new Byrd(-170.0f, MathUtils.random(25.0f, 70.0f))});
            }
            case "City Thugs": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getSlaver(-355.0f, -30.0f), new ShellMonster(50.0f, 10.0f)});
            }
            case "City Ancients": {
                return new MonsterGroup(new AbstractMonster[]{new Sentry(-305.0f, 30.0f), new SphericGuardian()});
            }
            case "SnakePlant": {
                return new MonsterGroup(new SnakePlant(-30.0f, -30.0f));
            }
            case "Flame Bruiser (One Orb)": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f)});
            }
            case "Flame Bruiser (Two Orb)": {
                return new MonsterGroup(new AbstractMonster[]{new FlameBruiser(), new FireOrb(180.0f, 50.0f), new FireOrb(-180.0f, 80.0f)});
            }
            case "Darkling Encounter": {
                return new MonsterGroup(new AbstractMonster[]{new Darkling(-440.0f, 10.0f), new Darkling(-140.0f, 30.0f), new Darkling(180.0f, -5.0f)});
            }
            case "GiantHead": {
                return new MonsterGroup(new GiantHead());
            }
            case "MultipleMaws": {
                return new MonsterGroup(new AbstractMonster[]{new Maw(-350.0f, 15.0f), new Maw(120.0f, -20.0f)});
            }
            case "Maw": {
                return new MonsterGroup(new Maw(-70.0f, 20.0f));
            }
            case "Serpent": {
                return new MonsterGroup(new Serpent());
            }
            case "sphere and 2 shapes": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getAncientShape(-435.0f, 10.0f), MonsterHelper.getAncientShape(-210.0f, 0.0f), new SphericGuardian(110.0f, 10.0f)});
            }
            case "SPHERE_COMBAT": {
                return new MonsterGroup(new AbstractMonster[]{MonsterHelper.getAncientShape(-475.0f, 10.0f), new OrbWalker(150.0f, 30.0f), MonsterHelper.getAncientShape(-250.0f, 0.0f)});
            }
            case "Orb Walker": {
                return new MonsterGroup(new OrbWalker(-30.0f, 30.0f));
            }
            case "Double Orb Walker": {
                return new MonsterGroup(new AbstractMonster[]{new OrbWalker(150.0f, 36.0f), new OrbWalker(-250.0f, 42.0f)});
            }
            case "Puppeteer": {
                return new MonsterGroup(new Puppeteer());
            }
            case "Ancient Shapes": {
                return MonsterHelper.spawnShapes(false);
            }
            case "Ancient Shapes Weak": {
                return MonsterHelper.spawnShapes(true);
            }
            case "Nemesis": {
                return new MonsterGroup(new Nemesis());
            }
            case "AwakenedOne": {
                return new MonsterGroup(new AbstractMonster[]{new AwakenedOne(100.0f, 15.0f), new Cultist(-298.0f, -10.0f, false), new Cultist(-590.0f, 10.0f, false)});
            }
            case "TimeEater": {
                return new MonsterGroup(new TimeEater());
            }
            case "Donu and Deca": {
                return new MonsterGroup(new AbstractMonster[]{new Deca(), new Donu()});
            }
            case "CorruptHeart": {
                return new MonsterGroup(new CorruptHeart());
            }
        }
        logger.info("Unspecified key: " + key + " in MonsterHelper.");
        return new MonsterGroup(new ApologySlime());
    }

    public static AbstractMonster getMonster(String key) {
        switch (key) {
            case "AcidSlime_L": {
                return new AcidSlime_L(0.0f, 0.0f, 0, 1);
            }
            case "AcidSlime_M": {
                return new AcidSlime_M(0.0f, 0.0f, 0, 1);
            }
            case "AcidSlime_S": {
                return new AcidSlime_S(0.0f, 0.0f, 0);
            }
            case "Apology Slime": {
                return new ApologySlime();
            }
            case "Cultist": {
                return new Cultist(0.0f, 0.0f);
            }
            case "FungiBeast": {
                return new FungiBeast(0.0f, 0.0f);
            }
            case "GremlinFat": {
                return new GremlinFat(0.0f, 0.0f);
            }
            case "GremlinNob": {
                return new GremlinNob();
            }
            case "GremlinThief": {
                return new GremlinThief(0.0f, 0.0f);
            }
            case "GremlinTsundere": {
                return new GremlinTsundere(0.0f, 0.0f);
            }
            case "GremlinWarrior": {
                return new GremlinWarrior(0.0f, 0.0f);
            }
            case "GremlinWizard": {
                return new GremlinWizard(0.0f, 0.0f);
            }
            case "Hexaghost": {
                return new Hexaghost();
            }
            case "JawWorm": {
                return new JawWorm(0.0f, 0.0f);
            }
            case "Lagavulin": {
                return new Lagavulin(false);
            }
            case "Looter": {
                return new Looter(0.0f, 0.0f);
            }
            case "FuzzyLouseDefensive": {
                return new LouseDefensive(0.0f, 0.0f);
            }
            case "FuzzyLouseNormal": {
                return new LouseNormal(0.0f, 0.0f);
            }
            case "Sentry": {
                return new Sentry(0.0f, 0.0f);
            }
            case "SlaverBlue": {
                return new SlaverBlue(0.0f, 0.0f);
            }
            case "SlaverRed": {
                return new SlaverRed(0.0f, 0.0f);
            }
            case "SlimeBoss": {
                return new SlimeBoss();
            }
            case "SpikeSlime_L": {
                return new SpikeSlime_L(0.0f, 0.0f, 0, 1);
            }
            case "SpikeSlime_M": {
                return new SpikeSlime_M(0.0f, 0.0f, 0, 1);
            }
            case "SpikeSlime_S": {
                return new SpikeSlime_S(0.0f, 0.0f, 0);
            }
            case "TheGuardian": {
                return new TheGuardian();
            }
        }
        switch (key) {
            case "BanditBear": {
                return new BanditBear(0.0f, 0.0f);
            }
            case "BanditChild": {
                return new BanditChild(0.0f, 0.0f);
            }
            case "BanditLeader": {
                return new BanditLeader();
            }
            case "BookOfStabbing": {
                return new BookOfStabbing();
            }
            case "BronzeAutomaton": {
                return new BronzeAutomaton();
            }
            case "BronzeOrb": {
                return new BronzeOrb(0.0f, 0.0f, 0);
            }
            case "Byrd": {
                return new Byrd(0.0f, 0.0f);
            }
            case "Centurion": {
                return new Centurion(0.0f, 0.0f);
            }
            case "Champ": {
                return new Champ();
            }
            case "Chosen": {
                return new Chosen();
            }
            case "GremlinLeader": {
                return new GremlinLeader();
            }
            case "Healer": {
                return new Healer(0.0f, 0.0f);
            }
            case "Mugger": {
                return new Mugger(0.0f, 0.0f);
            }
            case "Shelled Parasite": {
                return new ShellMonster();
            }
            case "SnakePlant": {
                return new SnakePlant(0.0f, 0.0f);
            }
            case "Snecko": {
                return new Snecko();
            }
            case "SphericGuardian": {
                return new SphericGuardian();
            }
            case "SlaverBoss": {
                return new Taskmaster(0.0f, 0.0f);
            }
            case "TheCollector": {
                return new TheCollector();
            }
            case "TorchHead": {
                return new TorchHead(0.0f, 0.0f);
            }
        }
        switch (key) {
            case "AwakenedOne": {
                return new AwakenedOne(0.0f, 0.0f);
            }
            case "Darkling": {
                return new Darkling(0.0f, 0.0f);
            }
            case "Deca": {
                return new Deca();
            }
            case "Donu": {
                return new Donu();
            }
            case "Exploder": {
                return new Exploder(0.0f, 0.0f);
            }
            case "FireOrb": {
                return new FireOrb(0.0f, 0.0f);
            }
            case "FlameBruiser": {
                return new FlameBruiser();
            }
            case "GiantHead": {
                return new GiantHead();
            }
            case "Maw": {
                return new Maw(0.0f, 0.0f);
            }
            case "Nemesis": {
                return new Nemesis();
            }
            case "Orb Walker": {
                return new OrbWalker(0.0f, 0.0f);
            }
            case "Puppeteer": {
                return new Puppeteer();
            }
            case "Repulsor": {
                return new Repulsor(0.0f, 0.0f);
            }
            case "Serpent": {
                return new Serpent();
            }
            case "Spiker": {
                return new Spiker(0.0f, 0.0f);
            }
            case "TimeEater": {
                return new TimeEater();
            }
        }
        return new ApologySlime();
    }

    private static float randomYOffset(float y) {
        return y + MathUtils.random(-20.0f, 20.0f);
    }

    private static float randomXOffset(float x) {
        return x + MathUtils.random(-20.0f, 20.0f);
    }

    public static AbstractMonster getGremlin(String key, float xPos, float yPos) {
        switch (key) {
            case "GremlinWarrior": {
                return new GremlinWarrior(xPos, yPos);
            }
            case "GremlinThief": {
                return new GremlinThief(xPos, yPos);
            }
            case "GremlinFat": {
                return new GremlinFat(xPos, yPos);
            }
            case "GremlinTsundere": {
                return new GremlinTsundere(xPos, yPos);
            }
            case "GremlinWizard": {
                return new GremlinWizard(xPos, yPos);
            }
        }
        logger.info("UNKNOWN GREMLIN: " + key);
        return null;
    }

    public static AbstractMonster getAncientShape(float x, float y) {
        switch (MathUtils.random(2)) {
            case 0: {
                return new Spiker(x, y);
            }
            case 1: {
                return new Repulsor(x, y);
            }
        }
        return new Exploder(x, y);
    }

    public static AbstractMonster getShape(String key, float xPos, float yPos) {
        switch (key) {
            case "Repulsor": {
                return new Repulsor(xPos, yPos);
            }
            case "Spiker": {
                return new Spiker(xPos, yPos);
            }
            case "Exploder": {
                return new Exploder(xPos, yPos);
            }
        }
        logger.info("UNKNOWN SHAPE: " + key);
        return null;
    }

    private static MonsterGroup spawnShapes(boolean weak) {
        ArrayList<String> shapePool = new ArrayList<String>();
        shapePool.add("Repulsor");
        shapePool.add("Repulsor");
        shapePool.add("Exploder");
        shapePool.add("Exploder");
        shapePool.add("Spiker");
        shapePool.add("Spiker");
        AbstractMonster[] retVal = weak ? new AbstractMonster[3] : new AbstractMonster[4];
        int index = MathUtils.random(shapePool.size() - 1);
        String key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[0] = MonsterHelper.getShape(key, -480.0f, 6.0f);
        index = MathUtils.random(shapePool.size() - 1);
        key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[1] = MonsterHelper.getShape(key, -240.0f, -6.0f);
        index = MathUtils.random(shapePool.size() - 1);
        key = (String)shapePool.get(index);
        shapePool.remove(index);
        retVal[2] = MonsterHelper.getShape(key, 0.0f, -12.0f);
        if (!weak) {
            index = MathUtils.random(shapePool.size() - 1);
            key = (String)shapePool.get(index);
            shapePool.remove(index);
            retVal[3] = MonsterHelper.getShape(key, 240.0f, 12.0f);
        }
        return new MonsterGroup(retVal);
    }

    private static MonsterGroup spawnSmallSlimes() {
        AbstractMonster[] retVal = new AbstractMonster[2];
        if (MathUtils.randomBoolean()) {
            retVal[0] = new SpikeSlime_S(-230.0f, 32.0f, 0);
            retVal[1] = new AcidSlime_M(35.0f, 8.0f);
        } else {
            retVal[0] = new AcidSlime_S(-230.0f, 32.0f, 0);
            retVal[1] = new SpikeSlime_M(35.0f, 8.0f);
        }
        return new MonsterGroup(retVal);
    }

    private static MonsterGroup spawnManySmallSlimes() {
        ArrayList<String> slimePool = new ArrayList<String>();
        slimePool.add("SpikeSlime_S");
        slimePool.add("SpikeSlime_S");
        slimePool.add("SpikeSlime_S");
        slimePool.add("AcidSlime_S");
        slimePool.add("AcidSlime_S");
        AbstractMonster[] retVal = new AbstractMonster[5];
        int index = MathUtils.random(slimePool.size() - 1);
        String key = (String)slimePool.get(index);
        slimePool.remove(index);
        retVal[0] = key.equals("SpikeSlime_S") ? new SpikeSlime_S(-480.0f, 30.0f, 0) : new AcidSlime_S(-480.0f, 30.0f, 0);
        index = MathUtils.random(slimePool.size() - 1);
        key = (String)slimePool.get(index);
        slimePool.remove(index);
        retVal[1] = key.equals("SpikeSlime_S") ? new SpikeSlime_S(-320.0f, 2.0f, 0) : new AcidSlime_S(-320.0f, 2.0f, 0);
        index = MathUtils.random(slimePool.size() - 1);
        key = (String)slimePool.get(index);
        slimePool.remove(index);
        retVal[2] = key.equals("SpikeSlime_S") ? new SpikeSlime_S(-160.0f, 32.0f, 0) : new AcidSlime_S(-160.0f, 32.0f, 0);
        index = MathUtils.random(slimePool.size() - 1);
        key = (String)slimePool.get(index);
        slimePool.remove(index);
        retVal[3] = key.equals("SpikeSlime_S") ? new SpikeSlime_S(10.0f, -12.0f, 0) : new AcidSlime_S(10.0f, -12.0f, 0);
        index = MathUtils.random(slimePool.size() - 1);
        key = (String)slimePool.get(index);
        slimePool.remove(index);
        retVal[4] = key.equals("SpikeSlime_S") ? new SpikeSlime_S(200.0f, 9.0f, 0) : new AcidSlime_S(200.0f, 9.0f, 0);
        return new MonsterGroup(retVal);
    }

    private static MonsterGroup spawnGremlins() {
        ArrayList<String> gremlinPool = new ArrayList<String>();
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinTsundere");
        gremlinPool.add("GremlinWizard");
        AbstractMonster[] retVal = new AbstractMonster[4];
        int index = MathUtils.random(gremlinPool.size() - 1);
        String key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[0] = MonsterHelper.getGremlin(key, -320.0f, 25.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[1] = MonsterHelper.getGremlin(key, -160.0f, -12.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[2] = MonsterHelper.getGremlin(key, 25.0f, -35.0f);
        index = MathUtils.random(gremlinPool.size() - 1);
        key = (String)gremlinPool.get(index);
        gremlinPool.remove(index);
        retVal[3] = MonsterHelper.getGremlin(key, 205.0f, 40.0f);
        return new MonsterGroup(retVal);
    }

    private static AbstractMonster spawnGremlin(float x, float y) {
        ArrayList<String> gremlinPool = new ArrayList<String>();
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinWarrior");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinThief");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinFat");
        gremlinPool.add("GremlinTsundere");
        gremlinPool.add("GremlinWizard");
        return MonsterHelper.getGremlin((String)gremlinPool.get(MathUtils.random(0, gremlinPool.size() - 1)), x, y);
    }

    private static MonsterGroup bottomHumanoid() {
        AbstractMonster[] monsters = new AbstractMonster[]{MonsterHelper.bottomGetStrongHumanoid(MonsterHelper.randomXOffset(-130.0f), MonsterHelper.randomYOffset(20.0f)), MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(130.0f), MonsterHelper.randomYOffset(20.0f))};
        return new MonsterGroup(monsters);
    }

    private static MonsterGroup bottomWildlife() {
        int numMonster = 2;
        AbstractMonster[] monsters = new AbstractMonster[numMonster];
        if (numMonster == 2) {
            monsters[0] = MonsterHelper.bottomGetStrongWildlife(MonsterHelper.randomXOffset(-150.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[1] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(150.0f), MonsterHelper.randomYOffset(20.0f));
        } else if (numMonster == 3) {
            monsters[0] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(-200.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[1] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(0.0f), MonsterHelper.randomYOffset(20.0f));
            monsters[2] = MonsterHelper.bottomGetWeakWildlife(MonsterHelper.randomXOffset(200.0f), MonsterHelper.randomYOffset(20.0f));
        }
        return new MonsterGroup(monsters);
    }

    private static AbstractMonster bottomGetStrongHumanoid(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(new Cultist(x, y));
        monsters.add(MonsterHelper.getSlaver(x, y));
        monsters.add(new Looter(x, y));
        monsters.removeIf(m -> m.id.equals(lastStrongHumanoid) || m.id.equals(lastEncounterName));
        AbstractMonster output = (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
        lastStrongHumanoid = output.id;
        return output;
    }

    private static AbstractMonster bottomGetStrongWildlife(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(new FungiBeast(x, y));
        monsters.add(new JawWorm(x, y));
        AbstractMonster output = (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
        return output;
    }

    private static AbstractMonster bottomGetWeakWildlife(float x, float y) {
        ArrayList<AbstractMonster> monsters = new ArrayList<AbstractMonster>();
        monsters.add(MonsterHelper.getLouse(x, y));
        monsters.add(new SpikeSlime_M(x, y, 0, MathUtils.random(28, 32)));
        monsters.add(new AcidSlime_M(x, y, 0, MathUtils.random(28, 32)));
        return (AbstractMonster)monsters.get(MathUtils.random(0, monsters.size() - 1));
    }

    private static AbstractMonster getSlaver(float x, float y) {
        if (MathUtils.randomBoolean()) {
            return new SlaverRed(x, y);
        }
        return new SlaverBlue(x, y);
    }

    private static AbstractMonster getLouse(float x, float y) {
        if (MathUtils.randomBoolean()) {
            return new LouseNormal(x, y);
        }
        return new LouseDefensive(x, y);
    }

    public static void uploadEnemyData() {
        ArrayList<String> derp = new ArrayList<String>();
        ArrayList<EnemyData> data = new ArrayList<EnemyData>();
        data.add(new EnemyData(BLUE_SLAVER_ENC, 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(CULTIST_ENC, 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(JAW_WORM_ENC, 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(TWO_LOUSE_ENC, 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(SMALL_SLIMES_ENC, 1, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(GREMLIN_GANG_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(LARGE_SLIME_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(LOOTER_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(LOTS_OF_SLIMES_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(LVL_1_THUGS_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(LVL_1_WILDLIFE_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(RED_SLAVER_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(THREE_LOUSE_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(TWO_FUNGI_ENC, 1, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(GREMLIN_NOB_ENC, 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(LAGAVULIN_ENC, 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(THREE_SENTRY_ENC, 1, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(LAGAVULIN_EVENT_ENC, 1, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData(MUSHROOMS_EVENT_ENC, 1, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData(GUARDIAN_ENC, 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(HEXAGHOST_ENC, 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(SLIME_BOSS_ENC, 1, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(CHOSEN_ENC, 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(SHELL_PARASITE_ENC, 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(SPHERE_GUARDIAN_ENC, 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(THREE_BYRDS_ENC, 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(TWO_THIEVES_ENC, 2, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(CHOSEN_FLOCK_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SENTRY_SPHERE_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SLAVER_PARASITE_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SNAKE_PLANT_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SNECKO_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(TANK_HEALER_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(THREE_CULTISTS_ENC, 2, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(GREMLIN_LEADER_ENC, 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(SLAVERS_ENC, 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(STAB_BOOK_ENC, 2, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(MASKED_BANDITS_ENC, 2, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData(AUTOMATON_ENC, 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(CHAMP_ENC, 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(COLLECTOR_ENC, 2, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(BRUISER_ONE_ENC, 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(ORB_WALKER_ENC, 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(THREE_DARKLINGS_ENC, 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(THREE_SHAPES_ENC, 3, EnemyData.MonsterType.WEAK));
        data.add(new EnemyData(BRUISER_TWO_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(FOUR_SHAPES_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(MAW_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(PUPPETEER_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SPHERE_TWO_SHAPES_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(SPIRE_GROWTH_ENC, 3, EnemyData.MonsterType.STRONG));
        data.add(new EnemyData(GIANT_HEAD_ENC, 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(NEMESIS_ENC, 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(TWO_ORB_WALKER_ENC, 3, EnemyData.MonsterType.ELITE));
        data.add(new EnemyData(MYSTERIOUS_SPHERE_ENC, 3, EnemyData.MonsterType.EVENT));
        data.add(new EnemyData(AWAKENED_ENC, 3, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(DONU_DECA_ENC, 3, EnemyData.MonsterType.BOSS));
        data.add(new EnemyData(TIME_EATER_ENC, 3, EnemyData.MonsterType.BOSS));
        for (EnemyData d : data) {
            derp.add(d.debugDetailedEnemyDataString());
        }
        LeaderboardPoster poster = new LeaderboardPoster();
        poster.setValues(LeaderboardPoster.LeaderboardDataType.ENEMY_DATA, "", EnemyData.debugDetailedEnemyDataHeader(), derp, false);
        Thread t = new Thread(poster);
        t.run();
    }
}

